jQuery(function($){

/*
	$("body").css("position","absolute");
	$("body").css("display","block");
	$("body").css("height","98%");
	$("body").css("width","99%");
	
	$(".r01gContainer").css("width","100%");
	$(".r01gContainer").css("height","100%");
	*/
	var oThis = this;
	
	var style = new OpenLayers.Style( 
			//estilo por defecto
			{
				graphicOpacity: 1,
				graphicWidth: 22,
	            graphicHeight: 26,
	            graphicYOffset: -27,
	            externalGraphic : $.rup.APP_STATICS + "/images/estacion.png",
	            cursor: "pointer"
	        }
		);
	
	/*Ext.onReady(function(){
		fncCargarStyles();
		inicializar.apply(oThis, []);		
	});*/
	
	function fncCargarStyles(){
		
		//obtengo la lista de bandas para definir los iconos que va a tener el mapa
		$.rup_ajax({
			url: $.rup.CTX_PATH+"banda/lista",
			dataType: 'json',
			type: "GET",
			async: false,
			contentType: 'application/json',		    
			success: function (resultado, ajaxOptions) {
				
				var arrRules = new Array();
				arrRules.length = resultado.length - 1;
				
				for (var i=0; i<resultado.length; i++){
					
					//reglas de estilo dependiendo del tipo
					arrRules[i] = new OpenLayers.Rule({
						  filter: new OpenLayers.Filter.Comparison({
						      type: OpenLayers.Filter.Comparison.EQUAL_TO,
						      property: "idBanda", //establezco el icono a asociar a la estacion en funcion del idBanda
						      value: resultado[i].idBanda
						  }),
						  symbolizer: {graphicWidth: 22,
				              		   graphicHeight: 26,
					                   graphicYOffset: -27,
					                   externalGraphic : $.rup.APP_STATICS + "/images/" + resultado[i].icono} //el icono viene definido de bd
						});
					
				}
				
				style.addRules(arrRules);
				
				
			},
			error: function (xhr, ajaxOptions, thrownError) {
				$("#feedbackMensajes").rup_feedback("set", $.rup.i18n.app.mensajes.error.datos_cargar_error, "error");
			}
		});
	}	
	
	function inicializar(){
		//var corejs = new COREJS("divMapa"/*null*/, 'http://www.geo.euskadi.ejiedes.net/bisorea/');
		var corejs = new COREJS("divMapa"/*null*/, STATICS_GEO_EUSKADI + '/');
		
		var initLoad = {
	    	onAppLoaded: function() {
	    	
	    		if (!FuncionesAyudaVisorGeoEuskadi.iniciado){
	    			//funciones de ayuda
					FuncionesAyudaVisorGeoEuskadi.init();
	    		}
	    		
       			var capa = FuncionesAyudaVisorGeoEuskadi.LocalizarObjeto.localizarFichero($.rup.CTX_PATH+"estacion/geojson?R01HNoPortal=true", "geojson", {projeccion: "EPSG:25830", attributes: {title: "title"}, noTitle: true, popUpDescriptionFn: fncCargarDetalle});
       			capa.styleMap = new OpenLayers.StyleMap(style);
       			
       			//cargo los avisos generales con el metodo definido en el _layout.js
       			cargarAvisosGenerales();
			}
		};
		
		COREProxy.componentMng.add(initLoad);
		
		corejs.parser( $.rup.APP_STATICS + '/scripts/aa17aCalidadAire/mapa/xml/conf_min.xml');
		
		
		
	};
	
	fncCargarStyles();
	inicializar.apply(oThis, []);	
	
});

function fncCargarDetalle(data){
	
	var divDetalle = $("#divPlantilla").clone();
	$(divDetalle).removeAttr("class");
	$(divDetalle).removeAttr("id");	
	
	if (data != null){
		var estacion = data.data.estacion;
		var avisos = data.data.avisos;
		var datosHorarios = data.data.datosHorarios;
		var banda = data.data.banda;
		
		$(divDetalle).find(".lblNomEstacion").text(estacion.nombreEstacion);
		$(divDetalle).find(".lblDireccion").text(estacion.direccionEstacion);
		$(divDetalle).find(".lblMunicipio").text(estacion.nombreMunicipio);
		$(divDetalle).find(".lblProvincia").text(estacion.nombreProvincia);
		
		//si hay avisos de la estación, los cargo
		if (avisos != null && avisos.length > 0){
			$(divDetalle).find(".tblAvisos").append(fncCargarTablaAvisosEstacion(avisos));
		}else{//si no hay avisos de la estación, oculto ese bloque
			$(divDetalle).find(".flsAvisos").addClass("ocultar");
		}
		
		if (banda != null){
			$(divDetalle).find(".lblValorICA").text(banda.descripcion);
			$(divDetalle).find(".imgICA").attr("src",APP_STATICS + "/images/" + banda.icono);
			$(divDetalle).find(".imgICA").attr("alt",banda.descripcion);
			$(divDetalle).find(".imgICA").attr("title",banda.descripcion);
		}		
		
		$(divDetalle).find(".tblContaminantes").append(fncCargarTablaContaminantes(datosHorarios, $(divDetalle)));
		
	}
	
	return $(divDetalle).html();
	
}

function fncCargarTablaAvisosEstacion(avisos){
	
	var objTbody = $(document.createElement("tbody"));
	
	if (avisos != null){
		for (var i=0; i<avisos.length;i++){
			var objTR = $(document.createElement("tr"));
		
			$(objTR).append(fncGenerarTD(avisos[i].textoAviso, "left"));
			
			$(objTbody).append(objTR);
		}
	}
	
	return $(objTbody);
	
}

function fncCargarTablaContaminantes(datosHorarios, objDiv){
	
	var objTbody = $(document.createElement("tbody"));
	
	var ultimaMedidaHoraria = "";
	
	if (datosHorarios != null){
		for (var i=0; i<datosHorarios.length;i++){
			var objTR = $(document.createElement("tr"));
		
			var nombreContaminante = datosHorarios[i].contaminante.nombreContaminante;
			var unidadMedida = datosHorarios[i].contaminante.unidadMedida;
			var banda = datosHorarios[i].banda;
			
			$(objTR).append(fncGenerarTD(nombreContaminante + " (" + unidadMedida + ")", "left"));
			$(objTR).append(fncGenerarTD(datosHorarios[i].ultimoValorHorario));
			
			var objTD = $(document.createElement("td"));
			
			//si tengo los datos de la banda, pinto el icono correspondiente
			if (banda != null){
				var icono = datosHorarios[i].banda.icono;
				var objIMG = $(document.createElement("img"));
				$(objIMG).attr("src", APP_STATICS + "/images/" + icono);
				$(objIMG).attr("width","22px");
				$(objIMG).attr("height","26px");
				$(objIMG).attr("alt",banda.descripcion);
				$(objIMG).attr("title",banda.descripcion);
				
				$(objTD).attr("align", "center");
				$(objTD).append(objIMG);
			}
			$(objTR).append(objTD);
			
			$(objTbody).append(objTR);
			
			ultimaMedidaHoraria = datosHorarios[i].fechaHoraUltimaMedidaHoraria;
		}
	}
	
	$(objDiv).find(".lblUltimaMedidaHoraria").text(ultimaMedidaHoraria);
	
	return $(objTbody);
	
}

function fncGenerarTD(pValor, pAlign){
	var objTD = $(document.createElement("td"));
	$(objTD).text(pValor);
	if (pAlign){
		$(objTD).attr("align", pAlign);
	}else{
		$(objTD).attr("align", "right");
	}
	
	return $(objTD);
}